c     -------------------------------------------------
c     FOURIER3: Solving non-linear Fourier's second law
c     in 1 dimension with non-linear boundary condition
c     -------------------------------------------------

      subroutine Func(n,info,f,y,dfdy,t,CalcJ,error,
     +                Dw,Iw,kountD,kountI)
c
      integer           n,info,error,kountD,kountI,Iw(*)
      double precision  f(n),y(n),dfdy(n,n),t,Dw(*)
      logical           CalcJ
      integer           nf,nj
      common   /score/  nf,nj
c
      integer           Tx,Txx,i
      double precision  zero,one
      parameter        (zero=0.0d0,one=1.0d0)
c
      integer           method
      double precision  l,alpha
      common /fourier1/ l,alpha,method
c
      nf = nf+1
c
c     Allocate Tx,Txx array
c
      Tx  = Nwork(n,kountD)
      Txx = Nwork(n,kountD)
c
      if (method .eq. 1) then
c
c       Solve directly
c
        call f1123(zero,l,n,Y,Dw(Tx),dfdy,.False.)
        Dw(Tx)     = zero
        Dw(Tx+n-1) = -Y(n)**4
        do i=1,n
          Dw(Tx+i-1) = (one+y(i))*Dw(Tx+i-1)
        enddo
        call f1123(zero,l,n,Dw(Tx),f,dfdy,CalcJ)
c
      else if (method .eq. 2) then
c
c     Expanded right hand side
c
        call f1123(zero,l,n,Y,Dw(Tx),dfdy,.False.)
        Dw(Tx)     = zero
        Dw(Tx+n-1) = -Y(n)**4
        call f1123(zero,l,n,Dw(Tx),Dw(Txx),dfdy,CalcJ)
        do i=1,n
          f(i) = (one+y(i))*Dw(Txx+i-1)+Dw(Tx+i-1)**2
        enddo
      endif
c
c     De-allocate Txx, Tx array
c
      Txx = Kwork(n,kountD)
      Tx  = Kwork(n,kountD)
      if (CalcJ) nj = nj + 1
c
      return
      end



      subroutine Init(n,t,h,tout,trep,Y,B,nd,NumJac,Atoler,Rtoler)
c
      integer           n,nd
      double precision  t,h,tout,trep,Y(nd),B(nd,nd),Atoler,Rtoler
      logical           NumJac
c
      integer           i
      double precision  zero,one
      parameter        (zero=0.0d0,one=1.0d0)
c
      integer           method
      double precision  l,alpha
      common /fourier1/ l,alpha,method
c
      write(*,*) 'Number of lines (1..10):'
      read(*,*) n
      if ((n .lt. 1) .or. (n .gt. 10)) then
        n=11
      else
        n=5*n+1
      endif
      write(*,*) 'Method (1/2):'
      read(*,*) method
      if ((method .lt. 1) .or. (method .gt. 2)) method=1
c
      write(*,*) 'Solving non-linear Fourier''s second law in 1'
      write(*,*) 'coordinate with non-linear boundary condition'
      write(*,1) n
 1    format('using the method of lines and',i3,' points:')
      if (method .eq. 1) then
        write(*,*) 'Directly approximated (k(T)Tx)x'
      else if (method .eq. 2) then
        write(*,*) 'Expanded (k(T)Tx)x into k(T).Txx + (dK/dT).Tx.Tx'
      endif
      write(*,*)
      write(*,*) '  Tt = (k(T)Tx)x,   T(x,0) = 1'
      write(*,*)
      write(*,*) '  k(T) = 1+T'
      write(*,*) '                             3  4'
      write(*,*) '  Tx(0,t) = 0   Tx(L,t) = -10 .T'
      write(*,*)
      l = one
      alpha = 1.d3
      t = zero
      tout = 2.0d0
      trep = 0.2d0
      do i=1,n
        Y(i)=one
      enddo
      call Mat0(B,nd,n)
      do i=1,n
        B(i,i)=one
      enddo
      NumJac=.True.
      Atoler=1.0d-6
      Rtoler=0.0d0
c
      return
      end



      integer function Rept(n,iter,info,t,treprt,Y,E)
c
      integer           n,iter,info
      double precision  t,Y(n),E(n),treprt
c
      integer           i,nn
c
      nn=n/5
      write(*,2) t,(Y(i),i=1,n,nn)
 2    format(//,'Time = ',F6.3,/,15X,
     +          '  x=0',5X,'x=0.2',5X,'x=0.4',5X,
     +          'x=0.6',5X,'x=0.8',5X,'  x=1',/,
     +          '    T(x,t)',6F10.6,/)
      Rept=0
c
      return
      end



c$include besirk.for
c$include main.for
c$include sd.for
