c     -----------------------------------------
c     PENDULUM: Solving Pendulum Problem
c     -----------------------------------------

      subroutine Func(n,info,f,y,dfdy,t,CalcJ,error,
     +                Dw,Iw,kountD,kountI)
c
      integer           n,info,error,kountD,kountI,Iw(*)
      double precision  f(n),y(n),dfdy(n,n),t,Dw(*)
      logical           CalcJ
c
      integer           nf,nj
      common   /score/  nf,nj
c
      double precision  y12,y22,y32
c
      nf=nf+1
      y12 = y(1)**2
      y22 = y(2)**2
      y32 = y(3)**2
c
c     Differential equations
c
      f(1) = y(1)*y22*y32
      f(2) = ( y12-3.0d0*y(3) )*y22
c
c     Algebraic equation
c
      f(3) = y12*y(2)-1.0d0
c
      if (CalcJ) then
        nj = nj + 1
        call mat0(dfdy,n,n)
        dfdy(1,1) = y22*y32
        dfdy(1,2) = y(1)*2.d0*y(2)*y32
        dfdy(1,3) = y(1)*y22*2.d0*y(3)
        dfdy(2,1) = 2.d0*y(1)*y22
        dfdy(2,2) = ( y12-3.0d0*y(3) )*2.d0*y(2)
        dfdy(2,3) = -3.d0*y22
        dfdy(3,1) = 2.d0*y(1)*y(2)
        dfdy(3,2) = y12
        dfdy(3,3) = 0.0d0
      endif
c
      return
      end



      subroutine Init(n,t,h,tout,trep,Y,B,nd,NumJac,Atoler,Rtoler)
c
      integer           n,nd
      double precision  t,h,tout,trep,Y(nd),B(nd,nd),Atoler,Rtoler
      logical           NumJac
c
      integer           i
      double precision  zero,one
      parameter        (zero=0.0d0,one=1.0d0)
c
      n     = 3
      t     = zero
      tout  = one
      Atoler=1.0d-6
      write(*,*) 'Solving problem'
      write(*,*) '  y1'' =  y1*y2*y2*y3*y3'
      write(*,*) '  y2'' =  y1*y1*y2*y2-3*y2*y2*y3'
      write(*,*) '   0  =  y1*y1*y2 - 1'
      write(*,*)
      trep=tout
      y(1)=one
      y(2)=one
      y(3)=one
      call Mat0(B,nd,n)
      do i=1,n-1
        B(i,i)=one
      enddo
      NumJac=.False.
      Rtoler=0.0d0
c
      return
      end



      integer function Rept(n,iter,info,t,treprt,Y,E)
c
      integer           n,iter,info
      double precision  t,Y(n),E(n),treprt
c
      double precision  g
c
      g = y(1)**2*y(2)-1.0d0
c
      write(*,1) t,(Y(i),i=1,n)
 1    format(F8.5,3F14.10)
      write(*,2) y(1)-dexp(t),y(2)-dexp(-2.d0*t),y(3)-dexp(2.d0*t),g
 2    format(8X,4F14.10)
      Rept=0
c
      return
      end



c$include besirk.for
c$include main.for
