c     -----------------------------------------
c     BINDIST1: Binary Batch Distillation 1.
c     -----------------------------------------

      subroutine Func(n,info,f,y,dfdy,t,CalcJ,error,
     +                Dw,Iw,kountD,kountI)
c
      integer           n,info,error,kountD,kountI,Iw(*)
      double precision  f(n),y(n),dfdy(n,n),t,Dw(*)
      logical           CalcJ
c
      integer           nf,nj
      common   /score/  nf,nj
c
      integer           mdim,i
      parameter        (mdim=10)
      double precision  e,Z,yy(mdim),yb
c
      integer           m,ie,Hb,xb,xd,i1,i2,x
      double precision  alpha,V,Hj,Hc,HB0,Cv,Zss,Kc,Ti,xdset,R,D
      common /bindist/  m,ie,Hb,xb,xd,i1,i2,x,
     +                  alpha,V,Hj,Hc,HB0,Cv,Zss,Kc,Ti,xdset,R,D
c
      nf=nf+1
c
c     Controller equations:
c
      e = Y(xd) - xdset
      f(ie) = e
      Z = Zss + Kc*(e + Y(ie)/Ti)
      if (Z .lt. 0.d0) Z=0.d0
      if (Z .gt. 1.d0) Z=1.d0
      D = Cv*Z*dsqrt(Hc)
      R = V - D
c
c     Compute vapour phase compositions:
c
      do i=1,m
        yy(i) = alpha*Y(x+i) / (1.d0+(alpha-1.d0)*Y(x+i) )
      enddo
      yb = alpha*Y(xb) / (1.d0+(alpha-1.d0)*Y(xb) )
c
c     Total & component molar balance Kettle reboiler:
c
      f(Hb) = R - V
      f(xb) = (Y(x+m)*R - yb*V - Y(xb)*(R-V) ) / Y(Hb)
c
c     Component balances for all trays in the column:
c
      f(x+1) = ( Y(xd)*R + yy(2)*V - Y(x+1)*R - yy(1)*V) / Hj
      do i=2,m-1
        f(x+i) = ( Y(x+i-1)*R + yy(i+1)*V - Y(x+i)*R - yy(i)*V) / Hj
      enddo
      f(x+m) = ( Y(x+m-1)*R + yb*V - Y(x+m)*R - yy(m)*V) / Hj
c
c     Component balance condenser:
c
      f(xd) = ( yy(1)*V - Y(xd)*(R+D) ) / Hc
c
c     Total distillate and distillate product:
c
      f(i1) = D
      f(i2) = D * Y(xd)
c
      return
      end



      subroutine Init(n,t,h,tout,trep,Y,B,nd,NumJac,Atoler,Rtoler)
c
      integer           n,nd
      double precision  t,h,tout,trep,Y(nd),B(nd,nd),Atoler,Rtoler
      logical           NumJac
c
      integer           i
      double precision  zero,one
      parameter        (zero=0.0d0,one=1.0d0)
c
      integer           m,ie,Hb,xb,xd,i1,i2,x
      double precision  alpha,V,Hj,Hc,HB0,Cv,Zss,Kc,Ti,xdset,R,D
      common /bindist/  m,ie,Hb,xb,xd,i1,i2,x,
     +                  alpha,V,Hj,Hc,HB0,Cv,Zss,Kc,Ti,xdset,R,D
c
c     Set model parameters:
c
      m     = 10
      alpha = 2.5d0
      V     = 5.0d0
      Hj    = 0.5d0
      Hc    = 3.0d0
      HB0   = 1.0d2
      Cv    = 2.309d0
      Zss   = 0.5d0
      Kc    = 1.0d1
      Ti    = 2.5d1
      xdset = 0.85d0
c
c     Offset of variables in vector Y:
c
      ie = 1
      Hb = 2
      xb = 3
      xd = 4
      i1 = 5
      i2 = 6
      x  = 6
c
      write(*,*) 'Solving Binary Batch Distillation 1'
      write(*,1) m,alpha
 1    format('with ',i2,' stages and relative volatility of ',f5.3)
      write(*,2) Kc,Ti
 2    format('and controller gain ',f5.2,' and integral time ',f5.2)
      write(*,3)
 3    format('   time  xd      xd-av   Product Reflux  Distillate')
c
      n     = m + 6
      t     = zero
      tout  = 40.0d0
      trep  = one
      Y(ie) = zero
      Y(Hb) = Hb0
      Y(xb) = 0.5d0
      Y(xd) = 0.5d0
      Y(i1) = zero
      Y(i2) = zero
      do i=1,m
        Y(x+i) = 0.5d0
      enddo
      call Mat0(B,nd,n)
      do i=1,n
        B(i,i) = one
      enddo
      NumJac = .True.
      Atoler = 1.0d-6
      Rtoler = 0.0d0
c
      return
      end



      integer function Rept(n,iter,info,t,treprt,Y,E)
c
      integer           n,iter,info
      double precision  t,Y(n),E(n),treprt
c
      integer           m,ie,Hb,xb,xd,i1,i2,x
      double precision  alpha,V,Hj,Hc,HB0,Cv,Zss,Kc,Ti,xdset,R,D
      common /bindist/  m,ie,Hb,xb,xd,i1,i2,x,
     +                  alpha,V,Hj,Hc,HB0,Cv,Zss,Kc,Ti,xdset,R,D
c
      double precision  q
c
      if (Y(i1) .eq. 0.d0) then
        q=0.d0
      else
        q=Y(i2)/Y(i1)
      endif
      write(*,1) t,Y(xd),q,Y(i1),R,D
 1    format(F7.1,5F8.4)
      Rept=0
c
      return
      end



c$include besirk.for
c$include main.for
