c     -----------------------------------------
c     REACTOR1: Solving ideal plug flow reactor
c     -----------------------------------------

      subroutine Func(n,info,f,y,dfdy,t,CalcJ,error,
     +                Dw,Iw,kountD,kountI)
c
      integer           n,info,error,kountD,kountI,Iw(*)
      double precision  f(n),y(n),dfdy(n,n),t,Dw(*)
      logical           CalcJ
c
      integer           nf,nj
      common   /score/  nf,nj
c
      double precision  Ksi,Theta,k
      double precision  k0,EAR,Ts,dH,rcp,Ca0,T0,dTad
      common  /reactor/ k0,EAR,Ts,dH,rcp,Ca0,T0,dTad
c
      nf=nf+1
c
      Ksi  =Y(1)
      Theta=Y(2)
      k    =k0*dexp(-EAR/(T0+dTad*Theta))
      f(1) =k*Ts*(1-Ksi)
      f(2) =k*Ts*(1-Ksi)
c
      return
      end



      subroutine Init(n,t,h,tout,trep,Y,B,nd,NumJac,Atoler,Rtoler)
c
      integer           n,nd
      double precision  t,h,tout,trep,Y(nd),B(nd,nd),Atoler,Rtoler
      logical           NumJac
c
      integer           i
      double precision  zero,one
      parameter        (zero=0.0d0,one=1.0d0)
      double precision  k0,EAR,Ts,dH,rcp,Ca0,T0,dTad
      common  /reactor/ k0,EAR,Ts,dH,rcp,Ca0,T0,dTad
c
      n   = 2
      k0  =   90.d0
      EAR = 5000.d0
      Ts  =   25.d0
      dH  =-6000.d0
      rcp =   12.d0
      Ca0 =    1.d0
      T0  =  500.d0
      dTad=(-dH)*Ca0/rcp
      write(*,*) 'Solving ideal plug flow reactor'
      write(*,1) T0
 1    format    ('Initial temperature = ',F5.1,' (K).')
      write(*,*)
      write(*,*) '   z (-)  E (-)   T (K)'
      t=zero
      tout=one
      trep=0.1d0
      Y(1)=zero
      Y(2)=zero
      call Mat0(B,nd,n)
      do i=1,n
        B(i,i)=one
      enddo
      NumJac=.True.
      Atoler=1.0d-6
      Rtoler=0.0d0
c
      return
      end



      integer function Rept(n,iter,info,t,treprt,Y,E)
c
      integer           n,iter,info
      double precision  t,Y(n),E(n),treprt
c
      double precision  k0,EAR,Ts,dH,rcp,Ca0,T0,dTad
      common  /reactor/ k0,EAR,Ts,dH,rcp,Ca0,T0,dTad
c
      write(*,1) t,Y(1),(T0+dTad*Y(2))
 1    format(F7.2,F9.4,F7.1)
      Rept=0
c
      return
      end



c$include besirk.for
c$include main.for
