c     ----------------------------------------------------
c     Harry Kooijman, April 1993.
c     ----------------------------------------------------
c     Spatial differentiation routines for Method Of Lines
c     from Dynamic Modeling of Transport Process Systems,
c     C.A. Silebi, W.E. Schiesser, Acedemic Press (1992).
c     ----------------------------------------------------

      subroutine dss002(xl,xu,n,u,ux)
c
c     Three point, 2nd order finite difference
c     approximation for first derivative
c
      integer          n
      double precision xl,xu,u(n),ux(n)
c
      integer          nm1,i
      double precision dx,r2fdx
c
      nm1=n-1
      dx=(xu-xl)/dble(nm1)
      r2fdx=0.5d0/dx
c
      ux(1)=r2fdx*(-3.d0*u(1)
     +             +4.d0*u(2)
     +                  -u(3))
c
      do i=2,nm1
        ux(i)=r2fdx*(-u(i-1)
     +               +u(i+1))
      enddo
c
      ux(n)=r2fdx*(      u(n-2)
     +             -4.d0*u(nm1)
     +             +3.d0*u(n))
c
      return
      end



      subroutine dss004(xl,xu,n,u,ux)
c
c     Five point, 4th order finite difference
c     approximation for first derivative
c
      integer          n
      double precision xl,xu,u(n),ux(n)
c
      integer          nm1,nm2,i
      double precision dx,r4fdx
c
      nm1=n-1
      nm2=n-2
      dx=(xu-xl)/dble(nm1)
      r4fdx=1.d0/(24.d0*dx)
c
      ux(1)  =r4fdx*(-50.d0*u(1)
     +               +96.d0*u(2)
     +               -72.d0*u(3)
     +               +32.d0*u(4)
     +                -6.d0*u(5))
c
      ux(2)  =r4fdx*( -6.d0*u(1)
     +               -20.d0*u(2)
     +               +36.d0*u(3)
     +               -12.d0*u(4)
     +                +2.d0*u(5))
c
      do i=3,nm2
        ux(i)=r4fdx*(  2.d0*u(i-2)
     +               -16.d0*u(i-1)
     +               +16.d0*u(i+1)
     +                -2.d0*u(i+2))
      enddo
c
      ux(nm1)=r4fdx*( -2.d0*u(n-4)
     +               +12.d0*u(n-3)
     +               -36.d0*u(nm2)
     +               +20.d0*u(nm1)
     +                +6.d0*u(n))
c
      ux(n)  =r4fdx*(  6.d0*u(n-4)
     +               -32.d0*u(n-3)
     +               +72.d0*u(nm2)
     +               -96.d0*u(nm1)
     +               +50.d0*u(n))
c
      return
      end



      subroutine dss012(xl,xu,n,u,ux,v)
c
c     Two point, 1st order directional finite difference
c     approximation for first derivative
c
      integer          n
      double precision xl,xu,u(n),ux(n)
c
      integer          nm1,i
      double precision dx,r2fdx,v
c
      nm1=n-1
      dx=(xu-xl)/dble(nm1)
      r2fdx=1.d0/dx
c
      if (v .lt. 0.d0) then
        ux(1)=r2fdx*(u(2)-u(1))
        do i=2,n
          ux(i)=r2fdx*(u(i)-u(i-1))
        enddo
      else
        do i=1,nm1
          ux(i)=r2fdx*(u(i+1)-u(i))
        enddo
        ux(n)=r2fdx*(u(n)-u(nm1))
      endif
c
      return
      end



      subroutine dss014(xl,xu,n,u,ux,v)
c
c     Three point, 2nd order directional finite difference
c     approximation for first derivative
c
      integer          n
      double precision xl,xu,u(n),ux(n)
c
      integer          nm1,nm2,i
      double precision dx,r2fdx,v
c
      nm1=n-1
      dx=(xu-xl)/dble(nm1)
      r2fdx=0.5d0/dx
c
      if (v .lt. 0.d0) then
        ux(1)=r2fdx*(-3.d0*u(1)
     +               +4.d0*u(2)
     +                    -u(3))
        ux(2)=r2fdx*(     -u(1)
     +                    +u(3))
        do i=3,n
          ux(i)=r2fdx*(      u(i-2)
     +                 -4.d0*u(i-1)
     +                 +3.d0*u(i))
        enddo
      else
        nm2=n-2
        do i=1,nm2
          ux(i)=r2fdx*(-3.d0*u(i)
     +                 +4.d0*u(i+1)
     +                      -u(i+2))
        enddo
        ux(nm1)=r2fdx*(     -u(nm2)
     +                      +u(n))
        ux(n)  =r2fdx*(      u(nm2)
     +                 -4.d0*u(nm1)
     +                 +3.d0*u(n))
      endif
c
      return
      end



      subroutine dss020(xl,xu,n,u,ux,v)
c
c     Five point, biased upwind, 2nd order directional finite difference
c     approximation for first derivative
c
      integer          n
      double precision xl,xu,u(n),ux(n)
c
      integer          nm1,nm2,nm3,nm4,i
      double precision dx,r4fdx,v
c
      nm1=n-1
      dx=(xu-xl)/dble(nm1)
      r4fdx=1.d0/(12.d0*dx)
c
      if (v .lt. 0.d0) then
        ux(1)=r4fdx*(-25.d0*u(1)
     +               +48.d0*u(2)
     +               -36.d0*u(3)
     +               +16.d0*u(4)
     +                -3.d0*u(5))
        ux(2)=r4fdx*( -3.d0*u(1)
     +               -10.d0*u(2)
     +               +18.d0*u(3)
     +                -6.d0*u(4)
     +                     +u(5))
        ux(3)=r4fdx*(      +u(1)
     +                -8.d0*u(2)
     +                -8.d0*u(4)
     +                     -u(5))
        do i=4,nm1
          ux(i)=r4fdx*(      -u(i-3)
     +                  +6.d0*u(i-2)
     +                 -18.d0*u(i-1)
     +                 +10.d0*u(i)
     +                  +3.d0*u(i+1))
        enddo
        ux(n)=r4fdx*(  3.d0*u(1)
     +               -16.d0*u(2)
     +               +36.d0*u(3)
     +               -48.d0*u(4)
     +               +25.d0*u(5))
      else
        nm4=n-4
        nm3=n-3
        nm2=n-2
        ux(1)  =r4fdx*(-25.d0*u(1)
     +                 +48.d0*u(2)
     +                 -36.d0*u(3)
     +                 +16.d0*u(4)
     +                  -3.d0*u(5))
        do i=2,nm3
          ux(i)=r4fdx*( -3.d0*u(i-1)
     +                 -10.d0*u(i)
     +                 +18.d0*u(i+1)
     +                  -6.d0*u(i+1)
     +                       +u(i+2))
        enddo
        ux(nm2)=r4fdx*(       u(nm4)
     +                  -8.d0*u(nm3)
     +                  +8.d0*u(nm1)
     +                       -u(n))
        ux(nm1)=r4fdx*(      -u(nm4)
     +                  +6.d0*u(nm3)
     +                 -18.d0*u(nm2)
     +                 +10.d0*u(nm1)
     +                  +3.d0*u(n))
        ux(n)  =r4fdx*(  3.d0*u(nm4)
     +                 -16.d0*u(nm3)
     +                 +36.d0*u(nm2)
     +                 -48.d0*u(nm1)
     +                 +25.d0*u(n))
      endif
c
      return
      end



      subroutine dss044(xl,xu,n,u,ux1,uxn,uxx,nl,nu)
c
c     Five (six) point, 2nd order finite difference
c     approximation for second derivative
c
      integer          n,nl,nu
      double precision xl,xu,u(n),ux1,uxn,uxx(n)
c
      integer          nm1,nm2,i
      double precision dx,r12dxs
c
      nm1=n-1
      nm2=n-2
      dx=(xu-xl)/dble(nm1)
      r12dxs=1.d0/(12.d0*dx**2)
c
      if (nl .eq. 1) then
        uxx(1)=r12dxs * (  45.d0*u(1)
     +                   -154.d0*u(2)
     +                   +214.d0*u(3)
     +                   -156.d0*u(4)
     +                    +61.d0*u(5)
     +                    -10.d0*u(6))
      else if (nl .eq. 2) then
        uxx(1)=r12dxs * (-415.d0/6.d0*u(1)
     +                         +96.d0*u(2)
     +                         -36.d0*u(3)
     +                    +32.d0/3.d0*u(4)
     +                     -3.d0/2.d0*u(5)
     +                         -50.d0*ux1*dx)
      endif
c
      uxx(2)  =r12dxs * (  10.d0*u(1)
     +                    -15.d0*u(2)
     +                     -4.d0*u(3)
     +                    +14.d0*u(4)
     +                     -6.d0*u(5)
     +                          +u(6))
c
      do i=3,nm2
        uxx(i)=r12dxs * (       -u(i-2)
     +                    +16.d0*u(i-1)
     +                    -30.d0*u(i)
     +                    +16.d0*u(i+1)
     +                          -u(i+2))
      enddo
c
      uxx(nm1)=r12dxs * (  10.d0*u(n)
     +                    -15.d0*u(nm1)
     +                     -4.d0*u(nm2)
     +                    +14.d0*u(n-3)
     +                     -6.d0*u(n-4)
     +                          +u(n-5))
c
      if (nu .eq. 1) then
        uxx(n)=r12dxs * (  45.d0*u(n)
     +                   -154.d0*u(nm1)
     +                   +214.d0*u(nm2)
     +                   -156.d0*u(n-3)
     +                    +61.d0*u(n-4)
     +                    -10.d0*u(n-5))
      else if (nu .eq. 2) then
        uxx(n)=r12dxs * (-415.d0/6.d0*u(n)
     +                         +96.d0*u(nm1)
     +                         -36.d0*u(nm2)
     +                    +32.d0/3.d0*u(n-3)
     +                     -3.d0/2.d0*u(n-4)
     +                         +50.d0*uxn*dx)
      endif
c
      return
      end

