c     ----------------------------------------------
c     Copyright (c) Harry Kooijman, April 1993.
c     ----------------------------------------------
c     This is a driver program for the examples that
c     illustrate the use of the DAE solver BESIRK.
c     ----------------------------------------------
c
      program demo
c
c     - We count function and jacobian evaluations -
c
      integer           nf,nj
      common   /score/  nf,nj
c
c     - For problems -
c
      integer           n,nB
      parameter        (nB=100)
      double precision  t,h,tout,trep,Y(nB),B(nB,nB),Atoler,Rtoler
c
c     - Workspace declaration -
c
      integer           nwork
      parameter        (nwork=10000)
      integer           kountI,kountD,Iwork(nwork)
      double precision  Dwork(nwork)
c
c     - For BESIRK -
c
      integer           info,result,MaxIt,Iter,i,StandU
      double precision  treprt,hnext,hmin,hmax,Nstep,
     +                  AbsTol(nB),Reltol(nB)
      logical           NumJac,AlgEqn,StandT
      External          StandU,StandT
c
c     - Problem routine -
c
      integer           Rept
      external          Func,Rept
c
c     - Stepsize is zero -> BESIRK finds it -
c
      h    = 0.0d0
c
c     - Initialize problem: -
c
      call Init(n,t,h,tout,trep,Y,B,nB,NumJac,Atoler,Rtoler)
c
c     - Initialize counters -
c
      nf = 0
      nj = 0
c
c     - Set info level -
c
      write(*,*) 'info='
      read(*,*) info
c
c     - Set next report time -
c
      write(*,*) 'report interval='
      read(*,*) treprt
c
c     - Set minimum and maximum stepsize -
c
      hmin = 1.0d-10
      hmax = tout
c
c     - Set numerical Jacobian step -
c
      Nstep = 1.0d-3
c
c     - Maximum number of iterations -
c
      MaxIt = 500
c
c     - Set tolerances (for each variable) -
c
      do i = 1, n
        AbsTol(i) = Atoler
        RelTol(i) = Rtoler
      enddo
      AlgEqn=.False.
c
c     - Set workspace counters -
c
      kountI = nwork
      kountD = nwork
c
c     - Solve -
c
      Iter = 0
      call Init3
      call BESIRK(n,info,Y,B,nB,t,tout,treprt,h,hnext,hmin,hmax,result,
     +            Nstep,Func,StandU,StandT,Rept,NumJac,MaxIt,Iter,
     +            AbsTol,RelTol,AlgEqn,Dwork,Iwork,kountD,kountI)
c
c     - Report -
c
      Write(*,*)
      Write(*,*) 'BESIRK returns      =',result
      Write(*,*) 'function evaluations=',nf
      Write(*,*) 'jacobian evaluations=',nj
      Write(*,*)
c
c     - Terminate -
c
      stop
      end
