c     --------------------------------------------
c     FOURIER2: Solving Fourier's second law in 1
c     dimension with non-linear boundary condition
c     --------------------------------------------

      subroutine Func(n,info,f,y,dfdy,t,CalcJ,error,
     +                Dw,Iw,kountD,kountI)
c
      integer           n,info,error,kountD,kountI,Iw(*)
      double precision  f(n),y(n),dfdy(n,n),t,Dw(*)
      logical           CalcJ
      integer           nf,nj
      common   /score/  nf,nj
c
      integer           Tx,i
      double precision  zero,one
      parameter        (zero=0.0d0,one=1.0d0)
      double precision  l,alpha
      common /fourier1/ l,alpha
c
      nf = nf+1
c
c     Allocate Tx array
c
      Tx = Nwork(n,kountD)
c
c     Approximate Txx by stagewise differentiation
c
      call f1123(zero,l,n,Y,Dw(Tx),dfdy,.False.)
c
c     Boundary conditions
c
      Dw(Tx)     = zero
      Dw(Tx+n-1) = -Y(n)**4
c
      call f1123(zero,l,n,Dw(Tx),f,dfdy,CalcJ)
c
c     De-allocate Tx array
c
      Tx = Kwork(n,kountD)
      if (CalcJ) nj = nj + 1
c
      return
      end



      subroutine Init(n,t,h,tout,trep,Y,B,nd,NumJac,Atoler,Rtoler)
c
      integer           n,nd
      double precision  t,h,tout,trep,Y(nd),B(nd,nd),Atoler,Rtoler
      logical           NumJac
c
      integer           i
      double precision  zero,one
      parameter        (zero=0.0d0,one=1.0d0)
      double precision  l,alpha
      common /fourier1/ l,alpha
c
      n = 11
      write(*,*) 'Solving Fourier''s second law in 1 coordinate'
      write(*,*) 'with non-linear boundary condition'
      write(*,1) n
 1    format('using the method of lines and',i3,' points:')
      write(*,*)
      write(*,*) '  Tt = Txx,     T(x,0) = 1'
      write(*,*) '                             3  4'
      write(*,*) '  Tx(0,t) = 0   Tx(L,t) = -10 .T'
      write(*,*)
      l = one
      alpha = 1.d3
      t = zero
      tout = 2.0d0
      trep = 0.2d0
      do i=1,n
        Y(i)=one
      enddo
      call Mat0(B,nd,n)
      do i=1,n
        B(i,i)=one
      enddo
      NumJac=.True.
      Atoler=1.0d-6
      Rtoler=0.0d0
c
      return
      end



      integer function Rept(n,iter,info,t,treprt,Y,E)
c
      integer           n,iter,info
      double precision  t,Y(n),E(n),treprt
c
      integer           i,nn
c
      nn=n/5
      write(*,2) t,(Y(i),i=1,n,nn)
 2    format(//,'Time = ',F6.3,/,15X,
     +          '  x=0',5X,'x=0.2',5X,'x=0.4',5X,
     +          'x=0.6',5X,'x=0.8',5X,'  x=1',/,
     +          '    T(x,t)',6F10.6,/)
      Rept=0
c
      return
      end



c$include besirk.for
c$include main.for
c$include sd.for
