c     -------------------------------------------
c     FOURIER1: Solving Fourier's second law in 1
c     dimension using the method of lines (MOL).
c     -------------------------------------------

      subroutine Func(n,info,f,y,dfdy,t,CalcJ,error,
     +                Dw,Iw,kountD,kountI)
c
      integer           n,info,error,kountD,kountI,Iw(*)
      double precision  f(n),y(n),dfdy(n,n),t,Dw(*)
      logical           CalcJ
      integer           nf,nj
      common   /score/  nf,nj
c
      integer           Tx,i
      double precision  zero,one
      parameter        (zero=0.0d0,one=1.0d0)
      double precision  l
      common /fourier1/ l
c
      nf = nf+1
c
c     Allocate Tx array
c
      Tx = Nwork(n,kountD)
c
c     Approximate Txx by stagewise differentiation
c
      call f1123(zero,l,n,Y,Dw(Tx),dfdy,.False.)
      call f1123(zero,l,n,Dw(Tx),f,dfdy,CalcJ)
c
c     De-allocate Tx array
c
      Tx = Kwork(n,kountD)
      if (CalcJ) nj = nj + 1
c
c     Keep boundary conditions on Y(1) and Y(n)
c
      f(1)=zero
      f(n)=zero
c
c      if (CalcJ) then
c        do i=1,n
c          dfdy(1,i)=zero
c          dfdy(n,i)=zero
c        enddo
c      endif
c
      return
      end



      subroutine Init(n,t,h,tout,trep,Y,B,nd,NumJac,Atoler,Rtoler)
c
      integer           n,nd
      double precision  t,h,tout,trep,Y(nd),B(nd,nd),Atoler,Rtoler
      logical           NumJac
c
      integer           i
      double precision  zero,one,dx,x,pi
      parameter        (zero=0.0d0,one=1.0d0)
      double precision  l
      common /fourier1/ l
c
      n = 11
      write(*,*) 'Solving Fourier''s second law in 1 coordinate'
      write(*,1) n
 1    format('using the method of lines and',i3,' points:')
      write(*,*)
      write(*,*) '  Tt = Txx,  T(x,0) = sin(pi.x/L)'
      write(*,*)
      write(*,*) '  T(0,t) = 0   T(L,t) = 0'
      write(*,*)
      l = one
      t = zero
      tout = one
      trep = 0.1d0
      call Vec0(Y,n)
      l=one
      dx=l/dble(n-1)
      pi=dacos(-one)
      do i=1,n
        x=dble(i-1)*dx
        Y(i)=dsin(pi*x/l)
      enddo
      call Mat0(B,nd,n)
      do i=1,n
        B(i,i)=one
      enddo
      NumJac=.True.
      Atoler=1.0d-6
      Rtoler=0.0d0
c
      return
      end



      integer function Rept(n,iter,info,t,treprt,Y,E)
c
      integer           n,iter,info
      double precision  t,Y(n),E(n),treprt
c
      integer           i,nn
      double precision  exact,te(51),diff(51),pi,dx,x
      double precision  l
      common /fourier1/ l
c
      nn=n/5
      pi=dacos(-1.0d0)
      dx=l/dble(n-1)
      do i=1,n,nn
        x=dble(i-1)*dx
        te(i)=dexp((-pi**2/l**2)*t)*dsin(pi*x/l)
        diff(i)=Y(i)-te(i)
      enddo
      write(*,2) t,(Y(i),i=1,n,nn),
     +             (te(i),i=1,n,nn),
     +             (diff(i),i=1,n,nn)
 2    format(//,'Time = ',F6.3,/,15X,
     +          '  x=0',5X,'x=0.2',5X,'x=0.4',5X,
     +          'x=0.6',5X,'x=0.8',5X,'  x=1',/,
     +          '    T(x,t)',6F10.6,/,
     +          '   Te(x,t)',6F10.6,/,
     +          ' Diff(x,t)',6F10.6,/)
      Rept=0
c
      return
      end



c$include besirk.for
c$include main.for
c$include sd.for
