c     ----------------------------------------
c     POREDIFF: One dimensional pore diffusion
c     ----------------------------------------

      subroutine Func(n,info,f,y,dfdy,t,CalcJ,error,
     +                Dw,Iw,kountD,kountI)
c
      integer           n,info,error,kountD,kountI,Iw(*)
      double precision  f(n),y(n),dfdy(n,n),t,Dw(*)
      logical           CalcJ
      integer           nf,nj
      common   /score/  nf,nj
c
      integer           Gz,i
      double precision  zero,one
      parameter        (zero=0.0d0,one=1.0d0)
c
      nf = nf+1
c
c     Workspace for first dirivative
c
      Gz  = Nwork(n,kountD)
c
c     Boundary condition G(0,t) = 1
c
      y(1) = one
c
c     First derivative
c
      call f1123(zero,one,n,Y,Dw(Gz),dfdy,.False.)
c
c     Boundary condition Gz(1,t) = 0
c
      Dw(Gz+n-1) = zero
c
c     Second derivative
c
      call f1123(zero,one,n,Dw(Gz),f,dfdy,CalcJ)
c
      Gz  = Kwork(n,kountD)
      if (CalcJ) nj = nj+1
c
      return
      end



      subroutine Init(n,t,h,tout,trep,Y,B,nd,NumJac,Atoler,Rtoler)
c
      integer           n,nd
      double precision  t,h,tout,trep,Y(nd),B(nd,nd),Atoler,Rtoler
      logical           NumJac
c
      integer           i
      double precision  zero,one
      parameter        (zero=0.0d0,one=1.0d0)
c
      n = 11
      write(*,*) 'One dimensional pore diffusion'
      write(*,1) n
 1    format('using the method of lines and',i3,' points:')
      write(*,*)
      write(*,*) '  Gt = Gzz,   G(z,0) = 0'
      write(*,*)
      write(*,*) '  G(0,t) = 1  Gz(1,t) = 0'
      write(*,*)
      t = zero
      tout = 1.0d0
      trep = 0.1d0
      call Vec0(Y,n)
      call Mat0(B,nd,n)
      do i=1,n
        B(i,i)=one
      enddo
      NumJac=.True.
      Atoler=1.0d-6
      Rtoler=0.0d0
c
      return
      end



      integer function Rept(n,iter,info,t,treprt,Y,E)
c
      integer           n,iter,info
      double precision  t,Y(n),E(n),treprt
c
      integer           i,nn
c
      nn=n/5
      write(*,2) t,(Y(i),i=1,n,nn)
 2    format(//,'Time = ',F6.3,/,15X,
     +          '  z=0',5X,'z=0.2',5X,'z=0.4',5X,
     +          'z=0.6',5X,'z=0.8',5X,'  z=1',/,
     +          '    G(x,t)',6F10.6,/)
      Rept=0
c
      return
      end



c$include besirk.for
c$include main.for
c$include sd.for
