c     -----------------------------------------
c     TUBEFLOW: Solving ideal plug flow through
c     a tube using the method of lines (MOL).
c     -----------------------------------------

      subroutine Func(n,info,f,y,dfdy,t,CalcJ,error,
     +                Dw,Iw,kountD,kountI)
c
      integer           n,info,error,kountD,kountI,Iw(*)
      double precision  f(n),y(n),dfdy(n,n),t,Dw(*)
      logical           CalcJ
      integer           nf,nj
      common   /score/  nf,nj
c
      double precision  zero,one
      parameter        (zero=0.0d0,one=1.0d0)
      double precision  l,v
      common /tubeflow/ l,v
c
      nf=nf+1
c
c     Boundary condition
c
      y(1)=one
c
c     Partial derivative Tx:
c
      call f1123(zero,l,n,Y,f,dfdy,CalcJ)
      if (CalcJ) nj=nj+1
      call ScVec(f,-v,f,n)
c
c     Boundary condition
c
      f(1)=zero
c
c      if (CalcJ) then
c        do j=1,n
c          dfdy(1,j)=zero
c        enddo
c      endif
c
      return
      end



      subroutine Init(n,t,h,tout,trep,Y,B,nd,NumJac,Atoler,Rtoler)
c
      integer           n,nd
      double precision  t,h,tout,trep,Y(nd),B(nd,nd),Atoler,Rtoler
      logical           NumJac
c
      integer           i
      double precision  zero,one
      parameter        (zero=0.0d0,one=1.0d0)
      double precision  l,v
      common /tubeflow/ l,v
c
      n = 11
      write(*,*) 'Solving ideal plug flow'
      write(*,1) n
 1    format('using the method of lines and',i3,' points:')
      write(*,*)
      write(*,*) '  Tt = -v Tx'
      write(*,*)
      write(*,*) '  T(x,0) = 0   T(0,t) = u(t)'
      write(*,*)
      write(*,*) '   Time    T(1,t)    Te(1,t)   Diff'
      l = one
      v = one
      t=zero
      tout=2.0001d0
      trep=0.1d0
      call Vec0(Y,n)
      Y(1)=one
      call Mat0(B,nd,n)
      do i=1,n
        B(i,i)=one
      enddo
      NumJac=.True.
      Atoler=1.0d-6
      Rtoler=0.0d0
c
      return
      end



      integer function Rept(n,iter,info,t,treprt,Y,E)
c
      integer           n,iter,info
      double precision  t,Y(n),E(n),treprt
c
      integer           i
      double precision  dx,x,te,diff
c
      double precision  l,v
      common /tubeflow/ l,v
c
      dx=l/dble(n-1)
      i=n
      x=dble(i-1)*dx
      if (t .ge. x*l/v) then
        te=1.0d0
      else
        te=0.0d0
      endif
      diff=Y(n)-te
      write(*,1) t,Y(n),te,diff
 1    format(F7.2,3F10.4)
      Rept=0
c
      return
      end



c$include besirk.for
c$include main.for
c$include sd.for
