c     -----------------------------------------
c     PENDULUM: Solving Pendulum Problem
c     -----------------------------------------

      subroutine Func(n,info,f,y,dfdy,t,CalcJ,error,
     +                Dw,Iw,kountD,kountI)
c
      integer           n,info,error,kountD,kountI,Iw(*)
      double precision  f(n),y(n),dfdy(n,n),t,Dw(*)
      logical           CalcJ
c
      integer           nf,nj
      common   /score/  nf,nj
c
      integer           index
      double precision  L,g
      common  /pendul/  L,g,index
c
      nf=nf+1
c
c     Differential equations
c
      f(1) =  y(3)
      f(2) =  y(4)
      f(3) = -y(1)*y(5)
      f(4) = -y(2)*y(5) - g
c
c     Algebraic equation
c
      if (index .eq. 1) then
        f(5) =  y(3)**2 + y(4)**2 - y(5)*L**2 - y(2)*g
      else if (index .eq. 2) then
        f(5) = y(1)*y(3) + y(2)*y(4)
      else if (index .eq. 3) then
        f(5) = y(1)**2 + y(2)**2 - L**2 + y(1)*y(3) + y(2)*y(4)
      endif
c
      if (CalcJ) then
        nj = nj + 1
        call mat0(dfdy,n,n)
        dfdy(1,3) = 1.d0
        dfdy(2,4) = 1.d0
        dfdy(3,1) = -y(5)
        dfdy(3,5) = -y(1)
        dfdy(4,2) = -y(5)
        dfdy(4,5) = -y(2)
        if (index .eq. 1) then
          dfdy(5,2) = -g
          dfdy(5,3) =  2.d0*y(3)
          dfdy(5,4) =  2.d0*y(4)
          dfdy(5,5) = -L**2
        else if (index .eq. 2) then
          dfdy(5,1) = y(3)
          dfdy(5,2) = y(4)
          dfdy(5,3) = y(1)
          dfdy(5,4) = y(2)
        else if (index .eq. 3) then
          dfdy(5,1) = 2.d0*y(1) + y(3)
          dfdy(5,2) = 2.d0*y(2) + y(4)
          dfdy(5,3) = y(1)
          dfdy(5,4) = y(2)
        endif
      endif
c
      return
      end



      subroutine Init(n,t,h,tout,trep,Y,B,nd,NumJac,Atoler,Rtoler)
c
      integer           n,nd
      double precision  t,h,tout,trep,Y(nd),B(nd,nd),Atoler,Rtoler
      logical           NumJac
c
      integer           i
      double precision  zero,one
      parameter        (zero=0.0d0,one=1.0d0)
c
      integer           index
      double precision  L,g
      common  /pendul/  L,g,index
c
      n     = 5
      L     = one
      g     = one
      t     = zero
      tout  = one
      Atoler=1.0d-6
      write(*,*) 'Select index (1/2/3):'
      read(*,*) index
      if ((index .lt. 1) .or. (index .gt. 3)) then
        index = 1
      endif
      write(*,1) index,t,tout
 1    format('Solving Pendulum (index ',i1,') problem for t=',
     +       f3.1,'..',f3.1':')
      write(*,*)
      write(*,*) '  y1'' =  y3'
      write(*,*) '  y2'' =  y4'
      write(*,*) '  y3'' = -y1*y5'
      write(*,*) '  y4'' = -y2*y5 - g'
      if (index .eq. 1) then
        write(*,*) '  y5  =  y3*y3 + y4*y4 - y5*L*L - y2*g'
      else if (index .eq. 2) then
        write(*,*) '  y5  =  y1*y3 + y2*y4'
      else if (index .eq. 3) then
        write(*,*) '  y5  =  y1*y1 + y2*y2 - L*L'
      endif
      write(*,*)
      write(*,2) L,g,Atoler
 2    format('  with L=',f4.2,', g=',f4.2,', Atol=',f10.8)
      write(*,*)
      trep=tout
      y(1)=one
      y(2)=zero
      y(3)=zero
      y(4)=one
      y(5)=one
      call Mat0(B,nd,n)
      do i=1,n-1
        B(i,i)=one
      enddo
      NumJac=.False.
      Rtoler=0.0d0
c
      return
      end



      integer function Rept(n,iter,info,t,treprt,Y,E)
c
      integer           n,iter,info
      double precision  t,Y(n),E(n),treprt
c
      integer           index
      double precision  L,g
      common  /pendul/  L,g,index
c
      double precision  g1,g2,g3
c
      g3=y(1)**2+y(2)**2-L**2
      g2=y(1)*y(3)+y(2)*y(4)
      g1=y(3)**2+y(4)**2-y(5)*L**2-y(2)*g
c
      write(*,1) t,(Y(i),i=1,n)
 1    format(F3.1,5F14.10)
      write(*,2) g3,g2,g1
 2    format(3X,3F14.10)
      Rept=0
c
      return
      end



c$include besirk.for
c$include main.for
